 aR  w - mP9      h	 o       nSystem-wide%SET (supportsEmsWindows, 0)
$NOLIST

NAME  ScreenCharRoutines

$INCLUDE (WinCnst3~Inc~)

CGROUP GROUP CODE

PUBLIC ScrDrawChars, ScrPatternChars

EXTRN	scrOrientation: BYTE
EXTRN	RotatePtsNorth: NEAR, InitWinParms: NEAR, StartPosition: NEAR

%IF (%supportsEmsWindows EQ 1) THEN (
EXTRN	RestoreEmsSlot
) FI

westOrEast  EQU 01b
$EJ

CODE SEGMENT PUBLIC 'CODE'
ASSUME  CS:CGROUP

; These mask values are stored in what appears to be reversed because
; they are that way to avoid having to do an XCHG DH,DL to make things faster.

Masks	DW 0FFFFH	; This is a filler to avoid a DEC BX
		DW 0FF7FH
		DW 0FF3FH
		DW 0FF1FH
		DW 0FF0FH
		DW 0FF07H
		DW 0FF03H
		DW 0FF01H
;		DW 0FF00H	; This isn't needed (see code)
$EJECT

; PROCEDURE ScrPatternChars (screen, windowWidth, windowHeight: WORD;
;  	                     xLoc, yLoc, xExtent, yExtent: INTEGER;
;		                     charTopClip, charLeftClip: WORD;
;                           charBottomClip, charRightClip: WORD;
;                           VAR ch: BYTES; count: WORD; VAR font: BYTES;
;                           ptn: Pattern; ptnXferMode: WORD);

; parameters & locals for ScrPatternChars

params	STRUC
	nextChSegment DW ?
	nextChIndex   DW ?
	nextChIncDec  DW ?
	nextChShift   DB ?
	eachChHeight  DB ?

	curPtnLimit   DW ?
	curPtnOffset  DW ?
	ptnChRoutine  DW ?
	saveClipAmt   DW ?

	bplLessRewind DW ?
	edge	         DB ?
	oddLineFlag   DB ?

	oldBP         DW ?
	oldDS         DW ?
	returnIP      DW ?
	returnCS      DW ?	; Not needed if a NEAR procedure

	ptnChVerb     DW  ?	; Also used to save chHeight
	ptnByte1      DB  ?
	ptnByte2      DB  ?
	ptnByte3      DB  ?
	ptnByte4      DB  ?
	ptnByte5      DB  ?
	ptnByte6      DB  ?
	ptnByte7      DB  ?
	ptnByte8      DB  ?

	pFontInfo     DD ?
	numChars      DW ?
	pChars        DD ?

	chRightClip   DW ?
	chBottomClip  DW ?
	chLeftClip    DW ?
	chTopClip     DW ?

	yExtent       DW ?
	xExtent       DW ?
	yLoc	         DW ?
	xLoc	         DW ?

	windowHeight  DW ?
	bytesPerLine  DW ?	; Passed in as windowWidth; changes later
	screen        DW ?
params	ENDS

localBytes     EQU 20
loc	        EQU [BP-localBytes]
paramBytes     EQU 42

;;; Begin code for patterns only

PtnCharVerbTable LABEL WORD
	DW	OFFSET PtnCharsDraw
	DW	OFFSET PtnCharsErase
	DW	OFFSET PtnCharsInvert
	DW	OFFSET PtnCharsMerge

;;; End code for patterns only

ScrPatternChars PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	SUB  SP, localBytes

;;; Begin code for patterns only

	MOV	BX, loc.ptnChVerb
	AND	BX, 3	; CASE table only has 4 valid choices
	SHL	BX, 1
	MOV	AX, CS:[OFFSET PtnCharVerbTable+BX]
	MOV	loc.ptnChRoutine, AX

	LEA	AX, loc.ptnByte8
	INC	AX
	MOV	loc.curPtnLimit, AX

;;; End code for patterns only

;*;*;* This change is needed to use the display in portrait mode

	MOV	AX, loc.xLoc
	MOV	BX, loc.yLoc
	MOV	CX, loc.xExtent
	MOV	SI, loc.yExtent
	MOV	DX, loc.bytesPerLine	; It is windowWidth at this point
	MOV	DI, loc.windowHeight

	CALL	RotatePtsNorth

	MOV	loc.xLoc, AX
	MOV	loc.yLoc, BX
	MOV	loc.bytesPerLine, DX	; Now it is really bytesPerLine

;*;*;* End of change

; DX and DI set by RotatePtsNorth

	MOV	AX, loc.screen	; get the screen segment value

	CALL	InitWinParms

	MOV	ES, AX	; set up ES as screen segment
	MOV	loc.edge, CL
	MOV	loc.windowHeight, DI	; save the value for later
	MOV	AX, DX
  SUB  AX, BX	; BX has "rewindDelta"
  MOV  loc.bplLessRewind, AX

%IF (%supportsEmsWindows EQ 1) THEN (
	PUSH	SI	; Save old ems slot
) FI

; CL, DX and DI set by InitWinParms

	MOV	AX, loc.yLoc
	MOV	BX, loc.xLoc

	CALL	StartPosition	; compute dest addr and shift count

	CMP	CL, 8
	JB	SaveInfoOnPtnCharStartPos

	SUB	CL, 8
	INC	DI	; Use word on odd boundary

SaveInfoOnPtnCharStartPos:
	MOV	loc.oddLineFlag, AL
	MOV	loc.nextChShift, CL
	MOV	loc.nextChIndex, DI
	MOV	loc.nextChSegment, ES

PtnOrientClippingDataNorth:
	MOV	AL, CS:scrOrientation
	MOV	BX, loc.chTopClip	; BX will be the top clip amt here
	MOV	CX, loc.chBottomClip	; CX will be the bottom clip amt here
	MOV	DX, loc.chLeftClip	; DX will be the left clip amt here
	MOV	DI, loc.chRightClip	; DI will be the right clip amt here

	TEST	AL, 1b
	JZ	PtnNorthOrSouthClipInit

	TEST	AL, 10b
	JNZ	PtnEastClipInit

PtnWestClipInit:
	XCHG	BX, CX
	XCHG	DX, DI

PtnEastClipInit:
	XCHG	BX, DI
	XCHG	BX, DX
	XCHG	CX, DX
	MOV	loc.saveClipAmt, CX
	XOR	CX, CX
	JMP	SHORT PtnClippingDataInited

PtnNorthOrSouthClipInit:
	TEST	AL, 10b
	JZ	PtnNorthClipInit

PtnSouthClipInit:
	XCHG	BX, CX
	XCHG	DX, DI

PtnNorthClipInit:
	MOV	loc.saveClipAmt, DI
	XOR	DI, DI	; Clip right is not used until last char

PtnClippingDataInited:
	MOV	loc.chTopClip, BX
	MOV	loc.chBottomClip, CX
	MOV	loc.chLeftClip, DX
	MOV	loc.chRightClip, DI

	CLD
	LDS	SI, loc.pFontInfo
	LES	DI, loc.pChars
	MOV	CX, loc.numChars

	MOV	DX, 1	; Default nextChIncDec to Inc (by 1)
	MOV	AL, CS:scrOrientation
	DEC	AX
	TEST	AL, 2
	JNZ	SetNextPtnCharIncDec

	NEG	DX	; Chars drawn in a south or west orientation
	ADD	DI, CX	; are actually drawn last char to first
	DEC	DI	; for efficiency

SetNextPtnCharIncDec:
	MOV	loc.nextChIncDec, DX
	MOV	AL, BYTE PTR DS:[SI].fiPixHeight
	MOV	loc.eachChHeight, AL	; Store charHeight as a local variable

PtnCharMainLoop:
	PUSH	ES	; Save pointer to characters
	PUSH	DI	; Save index to characters
	PUSH	SI	; Save index to beginning of font info
	PUSH	CX	; Save count of characters (left)

	MOV	AL, ES:[DI]	; Get next char
	MOV	AH, DS:[SI].fiFirstChar
	CMP	AL, AH
	JB	SubstDefaultPtnChar

	CMP	AL, DS:[SI].fiLastChar
	JBE	EndPtnCharRangeCheck

SubstDefaultPtnChar:
	MOV	AL, DS:[SI].fiDfltChar

EndPtnCharRangeCheck:
	SUB	AL, AH
	MOV	AH, 0	; AX now has index for charInfoTable
	SHL	AX, 1
	SHL	AX, 1	; There are 2 words of info for each char

	MOV	BX, OFFSET fiChInfBase
	ADD	BX, AX

	MOV	AL, DS:[SI+BX+0]	; Width of next character
	MOV	CH, loc.eachChHeight	; Height of next characters
	MOV	SI, DS:[SI+BX+2]	; Index to next characters bit information

	MOV	BL, AL	; Width of next character passed in BL
	TEST	CS:scrOrientation, westOrEast
	JZ	PtnCharHorizLoopEntry

	XCHG	BL, CH

PtnCharHorizLoopEntry:
	MOV	ES, loc.nextChSegment
	MOV	DI, loc.nextChIndex
	MOV	CL, loc.nextChShift

	MOV	BH, BYTE PTR loc.chLeftClip	  ; Use for clipping left side of chars
	CMP	BH, 8
	JB	PtnNotByteWideLeftClip

	MOV	AL, BH	; Get amount of clip on left
	AND	AL, 0F8H	; Determine its even multiples of 8 (16,24,)
	SUB	BL, AL	; Subtract this from the left clip width
	MOV	AL, BH	; Get amount of clip on left (again)
	SHR	AL, 1
	SHR	AL, 1
	SHR	AL, 1	; Divide by 8 to get number of bytes
	MUL	CH	; Multiply by the character height and
	ADD	SI, AX	; Skip that many data drawing bytes
	AND	BH, 7	; Remaining bytes to be clipped on left

PtnNotByteWideLeftClip:
	SUB	CH, BYTE PTR loc.chTopClip	   ; Take clipping at top into account
	SUB	CH, BYTE PTR loc.chBottomClip	; Take clipping at bottom into account
	SUB	BL, BYTE PTR loc.chRightClip	 ; Take clipping at right into account
	SUB	BL, BH	   ; Take clipping at left into account

;;; Begin code for patterns only

	MOV	BYTE PTR loc.ptnChVerb, CH	; Save height in reused variable ptnChVerb

;;; End code for patterns only

; At this point the registers are set up as follows:
;
;  DS:SI => Beginning of bit map info for this character
;  ES:DI => Screen location (wordwise) where the character goes
;  CL    =  Amt to rotate the character to the right to position it
;  CH    =  Height of character (or width of image if portrait mode)
;  BL    =  Width of character (or height of image if portrait mode)
;  BH    =  Amount to be clipped at left of a character
;  AX    =  Available for use as a temporary variable

PtnCharHorizLoop:

;;; Begin code for patterns only

	MOV	AX, loc.yLoc
	AND	AX, 7
	LEA	DX, loc.ptnByte1
	ADD	AX, DX
	MOV	loc.curPtnOffset, AX

;;; End code for patterns only

	MOV	AL, loc.oddLineFlag
	PUSH	AX	; Save oddLineFlag
	PUSH	BX	; Save char width (in BL), clip left (in BH)
	PUSH	CX	; Save char height (in CH) & shift amt (CL)
	PUSH	DI	; Save starting point for char image

	ADD	SI, loc.chTopClip	; Skip data for part of char clipped at top

	MOV	DX, 0FF00H	; Mask for 8 bits (or greater)
	CMP	BL, 8	; A maximum of 8 bits are transferred
	JAE	HaveMaskForNextPtnChar	; per character fragment

	MOV	AL, BH	; Save left clip amt in AL
	XOR	BH, BH
	SHL	BX, 1	; masks array is a word wide
	MOV	DX, WORD PTR CS:Masks[BX]
	MOV	BH, AL	; Restore left clip amt in AL

HaveMaskForNextPtnChar:
	ROR	DX, CL
	SUB	CL, BH	; Shift less by amount of clip at left
	JNC	PtnCharVertLoop

	ADD	CL, 16

; In this inner loop registers will be used as follows:
;
;  DS:SI => Next part of character to be put on display
;  ES:DI => Next place for character
;  CL    =  Character Shift Amount
;  CH    =  Loop count
;  DX    =  Mask register
;  BX    =  Temporary register
;  AX    =  Temporary register

PtnCharVertLoop:

;;; Begin code for patterns only

	MOV	BX, loc.curPtnOffset
	MOV	AX, BX
	MOV	BL, SS:[BX]
	MOV	BH, BL
	INC	AX
	MOV	loc.curPtnOffset, AX
	CMP	AX, loc.curPtnLimit
	JB	GetNextPtnCharFragment

	LEA	AX, loc.ptnByte1
	MOV	loc.curPtnOffset, AX

;;; End code for patterns only

GetNextPtnCharFragment:
	LODSB 
	XOR	AH, AH
	ROR	AX, CL

	NOT	DX
	AND	AX, DX
	NOT	DX

;;; Begin code for patterns only

	AND	AX, BX	; And the character with its pattern mask
	JMP	loc.ptnChRoutine	; Draw, erase, invert or merge the char

PtnCharsMerge:
	OR	ES:[DI], AX
	JMP	SHORT PtnCharVertLoopAfterVerb

PtnCharsInvert:
	XOR	ES:[DI], AX
	JMP	SHORT PtnCharVertLoopAfterVerb

PtnCharsErase:
	NOT	AX
	AND	ES:[DI], AX
	JMP	SHORT PtnCharVertLoopAfterVerb

PtnCharsDraw:
	MOV	BX, ES:[DI] 
	AND	BX, DX 
	OR	AX, BX 
	MOV	ES:[DI], AX

;;; End code for patterns only

PtnCharVertLoopAfterVerb:
	MOV	AL, loc.oddLineFlag	; get buffer flag
	INC	AX	; next line
	AND	AL, 3	; IF AX = 4 (last buffer) THEN
	JNZ	PtnCharVertLoopNextBuffer

	ADD	DI, loc.bplLessRewind	; go back to top
	JMP	SHORT PtnCharVertLoopEnd

PtnCharVertLoopNextBuffer:
	ADD	DI, loc.windowHeight	; go to next buffer
	CMP	AL, loc.edge
	JA	PtnCharVertLoopEnd

	ADD	DI, loc.bytesPerLine

PtnCharVertLoopEnd:
	MOV	loc.oddlineFlag, AL
	DEC	CH
	JNZ	PtnCharVertLoop

	ADD	SI, loc.chBottomClip	; Skip data for part of char clipped at botm

	MOV	DX, DI	; Save char's dest index for east/west info
	POP	DI	; Starting point for the character image
	POP	CX	; Restore char height (in CH)
	POP	BX	; Width of char displayed thus far
	POP	AX	; Restore oddLineFlag

	ADD	BL, BH	; Take left clipped part into account
	CMP	BL, 8	; Check to see if there is more to this char
	JBE	FindCharPosForNextPtnChar	; If not then go do next char

	ADD	CL, 8
	SUB	CL, BH
	CMP	CL, 8
	JB	PtnCharHorizLoopBottom

	SUB	CL, 8
	INC	DI	; Next byte position

PtnCharHorizLoopBottom:
	SUB	BL, 8	; Width left to do for to this char
	XOR	BH, BH	; Clipping only occurs for left of char
	MOV	loc.oddLineFlag, AL	; Restore oddLineFlag
	JMP	SHORT PtnCharHorizLoop	; Do the next part

; At this point need to establish the word and offset position for the next
; char.  It is a little bit different for each screen direction (N,W,S,E).

FindCharPosForNextPtnChar:
	SUB	BL, BH	; Adjust width to reflect part drawn only
	TEST	CS:scrOrientation, westOrEast
	JZ	NextPtnCharPosNorthSouth

NextPtnCharPosEastWest:
	MOV	DI, DX
	MOV	AL, loc.eachChHeight
	XOR	AH, AH
	DEC	AX
	SHR	AX, 1
	SHR	AX, 1
	SHR	AX, 1
	SUB	DI, AX

;;; Begin code for patterns only

	MOV	AX, loc.yLoc
	ADD	AL, BYTE PTR loc.ptnChVerb	; Here ptnChVerb is used to store chHeight
	ADC	AH, 0
	MOV	loc.yLoc, AX	; Pt to next y loc for pattern purposes

;;; End code for patterns only

	MOV	loc.chTopClip, 0	; Top clip only valid for first char
	POP	CX	; Restore count of characters (left)
	CMP	CX, 2	; If next char is not the last (first) char
	JNE	NextPtnCharPosEnd	; then don't change bottom clip amt

	MOV	AX, loc.saveClipAmt
	MOV	loc.chBottomClip, AX
	JMP	SHORT NextPtnCharPosEnd

NextPtnCharPosNorthSouth:
	MOV	loc.oddLineFlag, AL	; Restore oddLineFlag
	ADD	CL, BL
	CMP	CL, 8
	JB	NextPtnCharPosNSEnd

	SUB	CL, 8
	INC	DI	; Use word on odd boundary

NextPtnCharPosNSEnd:
	MOV	loc.nextChShift, CL

	MOV	loc.chLeftClip, 0	; Left clip only valid for first char
	POP	CX	; Restore count of characters (left)
	CMP	CX, 2	; If next char is not the last (first) char
	JNE	NextPtnCharPosEnd	; then don't change right clip amt

	MOV	AX, loc.saveClipAmt
	MOV	loc.chRightClip, AX

NextPtnCharPosEnd:
	MOV	loc.nextChIndex, DI

	POP	SI	; Restore index to beginning of font info
	POP	DI	; Restore index to characters
	POP	ES	; Restore pointer to characters

	ADD	DI, loc.nextChIncDec	; Point to next/prev character
	DEC	CX
	JZ	ScrPatternCharsExit
	JMP	PtnCharMainLoop

ScrPatternCharsExit:
%IF (%supportsEmsWindows EQ 1) THEN (
	POP	AX
	INC	AX
	JZ	ScrPatternCharsRet

	DEC	AX
	CALL	RestoreEmsSlot
) FI

ScrPatternCharsRet:
	MOV	SP, BP
	POP	BP
	POP	DS
	RET	paramBytes
ScrPatternChars ENDP

PURGE params, loc, localBytes, paramBytes
PURGE screen, bytesPerLine, windowHeight
PURGE xLoc, yLoc, xExtent, yExtent
PURGE chTopClip, chLeftClip, chBottomClip, chRightClip
PURGE pChars, numChars, pFontInfo
PURGE ptnByte1, ptnByte2, ptnByte3, ptnByte4
PURGE ptnByte5, ptnByte6, ptnByte7, ptnByte8, ptnChVerb
PURGE oldDS, oldBP, returnIP, returnCS
PURGE edge, oddLineFlag, bplLessRewind, saveClipAmt
PURGE ptnChRoutine, curPtnOffset, curPtnLimit
PURGE nextChSegment, nextChIndex, nextChIncDec, nextChShift, eachChHeight
$EJECT

; PROCEDURE ScrDrawChars (screen, windowWidth, windowHeight: WORD;
;  	                  xLoc, yLoc, xExtent, yExtent: INTEGER;
;		                  charTopClip, charLeftClip: WORD;
;                        charBottomClip, charRightClip: WORD;
;                        VAR ch: BYTES; count: WORD; VAR font: BYTES);

; parameters & locals for ScrDrawChars

params	STRUC
	nextChSegment DW ?
	nextChIndex   DW ?
	nextChIncDec  DW ?
	nextChShift   DB ?
	eachChHeight  DB ?

	saveClipAmt   DW ?

	bplLessRewind DW ?
	edge	         DB ?
	oddLineFlag   DB ?

	oldBP         DW ?
	oldDS         DW ?
	returnIP      DW ?
	returnCS      DW ?	; Not needed if a NEAR procedure

	pFontInfo     DD ?
	numChars      DW ?
	pChars        DD ?

	chRightClip   DW ?
	chBottomClip  DW ?
	chLeftClip    DW ?
	chTopClip     DW ?

	yExtent       DW ?
	xExtent       DW ?
	yLoc	         DW ?
	xLoc	         DW ?

	windowHeight  DW ?
	bytesPerLine  DW ?	; Passed in as windowWidth; changes later
	screen        DW ?
params	ENDS

localBytes     EQU 14
loc	        EQU [BP-localBytes]
paramBytes     EQU 32

ScrDrawChars PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	SUB  SP, localBytes

;*;*;* This change is needed to use the display in portrait mode

	MOV	AX, loc.xLoc
	MOV	BX, loc.yLoc
	MOV	CX, loc.xExtent
	MOV	SI, loc.yExtent
	MOV	DX, loc.bytesPerLine	; It is windowWidth at this point
	MOV	DI, loc.windowHeight

	CALL	RotatePtsNorth

	MOV	loc.xLoc, AX
	MOV	loc.yLoc, BX
	MOV	loc.bytesPerLine, DX	; Now it is really bytesPerLine

;*;*;* End of change

; DX and DI set by RotatePtsNorth

	MOV	AX, loc.screen	; get the screen segment value

	CALL	InitWinParms

	MOV	ES, AX	; set up ES as screen segment
	MOV	loc.edge, CL
	MOV	loc.windowHeight, DI	; save the value for later
	MOV	AX, DX
  SUB  AX, BX	; BX has "rewindDelta"
  MOV  loc.bplLessRewind, AX

%IF (%supportsEmsWindows EQ 1) THEN (
	PUSH	SI	; Save old ems slot
) FI

; CL, DX and DI set by InitWinParms

	MOV	AX, loc.yLoc
	MOV	BX, loc.xLoc

	CALL	StartPosition	; compute dest addr and shift count

	CMP	CL, 8
	JB	SaveInfoOnCharStartPos

	SUB	CL, 8
	INC	DI	; Use word on odd boundary

SaveInfoOnCharStartPos:
	MOV	loc.oddLineFlag, AL
	MOV	loc.nextChShift, CL
	MOV	loc.nextChIndex, DI
	MOV	loc.nextChSegment, ES

OrientClippingDataNorth:
	MOV	AL, CS:scrOrientation
	MOV	BX, loc.chTopClip	; BX will be the top clip amt here
	MOV	CX, loc.chBottomClip	; CX will be the bottom clip amt here
	MOV	DX, loc.chLeftClip	; DX will be the left clip amt here
	MOV	DI, loc.chRightClip	; DI will be the right clip amt here

	TEST	AL, 1b
	JZ	NorthOrSouthClipInit

	TEST	AL, 10b
	JNZ	EastClipInit

WestClipInit:
	XCHG	BX, CX
	XCHG	DX, DI

EastClipInit:
	XCHG	BX, DI
	XCHG	BX, DX
	XCHG	CX, DX
	MOV	loc.saveClipAmt, CX
	XOR	CX, CX
	JMP	SHORT ClippingDataInited

NorthOrSouthClipInit:
	TEST	AL, 10b
	JZ	NorthClipInit

SouthClipInit:
	XCHG	BX, CX
	XCHG	DX, DI

NorthClipInit:
	MOV	loc.saveClipAmt, DI
	XOR	DI, DI	; Clip right is not used until last char

ClippingDataInited:
	MOV	loc.chTopClip, BX
	MOV	loc.chBottomClip, CX
	MOV	loc.chLeftClip, DX
	MOV	loc.chRightClip, DI

	CLD
	LDS	SI, loc.pFontInfo
	LES	DI, loc.pChars
	MOV	CX, loc.numChars

	MOV	DX, 1	; Default nextChIncDec to Inc (by 1)
	MOV	AL, CS:scrOrientation
	DEC	AX
	TEST	AL, 2
	JNZ	SetNextCharIncDec

	NEG	DX	; Chars drawn in a south or west orientation
	ADD	DI, CX	; are actually drawn last char to first
	DEC	DI	; for efficiency

SetNextCharIncDec:
	MOV	loc.nextChIncDec, DX
	MOV	AL, BYTE PTR DS:[SI].fiPixHeight
	MOV	loc.eachChHeight, AL	; Store charHeight as a local variable

CharMainLoop:
	PUSH	ES	; Save pointer to characters
	PUSH	DI	; Save index to characters
	PUSH	SI	; Save index to beginning of font info
	PUSH	CX	; Save count of characters (left)

	MOV	AL, ES:[DI]	; Get next char
	MOV	AH, DS:[SI].fiFirstChar	; Get first char in table
	CMP	AL, AH	; If out of range
	JB	SubstDefaultChar	; then use default

	CMP	AL, DS:[SI].fiLastChar	; If in range
	JBE	EndCharRangeCheck	; then use as is

SubstDefaultChar:
	MOV	AL, DS:[SI].fiDfltChar	; Use default for out of range chars

EndCharRangeCheck:
	SUB	AL, AH
	MOV	AH, 0	; AX now has index for charInfoTable
	SHL	AX, 1
	SHL	AX, 1	; There are 2 words of info for each char

	MOV	BX, OFFSET fiChInfBase
	ADD	BX, AX

	MOV	AL, DS:[SI+BX+0]	; Width of next character
	MOV	CH, loc.eachChHeight	; Height of next characters
	MOV	SI, DS:[SI+BX+2]	; Index to next characters bit information

	MOV	BL, AL	; Width of next character passed in BL
	TEST	CS:scrOrientation, westOrEast
	JZ	CharHorizLoopEntry

	XCHG	BL, CH

CharHorizLoopEntry:
	MOV	ES, loc.nextChSegment
	MOV	DI, loc.nextChIndex
	MOV	CL, loc.nextChShift

	MOV	BH, BYTE PTR loc.chLeftClip	  ; Use for clipping left side of chars
	CMP	BH, 8
	JB	NotByteWideLeftClip

	MOV	AL, BH	; Get amount of clip on left
	AND	AL, 0F8H	; Determine its even multiples of 8 (16,24,)
	SUB	BL, AL	; Subtract this from the left clip width
	MOV	AL, BH	; Get amount of clip on left (again)
	SHR	AL, 1
	SHR	AL, 1
	SHR	AL, 1	; Divide by 8 to get number of bytes
	MUL	CH	; Multiply by the character height and
	ADD	SI, AX	; Skip that many data drawing bytes
	AND	BH, 7	; Remaining bytes to be clipped on left

NotByteWideLeftClip:
	SUB	CH, BYTE PTR loc.chTopClip	   ; Take clipping at top into account
	SUB	CH, BYTE PTR loc.chBottomClip	; Take clipping at bottom into account
	SUB	BL, BYTE PTR loc.chRightClip	 ; Take clipping at right into account
	SUB	BL, BH	   ; Take clipping at left into account

; At this point the registers are set up as follows:
;
;  DS:SI => Beginning of bit map info for this character
;  ES:DI => Screen location (wordwise) where the character goes
;  CL    =  Amt to rotate the character to the right to position it
;  CH    =  Height of character (or width of image if portrait mode)
;  BL    =  Width of character (or height of image if portrait mode)
;  BH    =  Amount to be clipped at left of a character
;  AX    =  Available for use as a temporary variable

CharHorizLoop:
	MOV	AL, loc.oddLineFlag
	PUSH	AX	; Save oddLineFlag
	PUSH	BX	; Save char width (in BL), clip left (in BH)
	PUSH	CX	; Save char height (in CH) & shift amt (CL)
	PUSH	DI	; Save starting point for char image

	ADD	SI, loc.chTopClip	; Skip data for part of char clipped at top

	MOV	DX, 0FF00H	; Mask for 8 bits (or greater)
	CMP	BL, 8	; A maximum of 8 bits are transferred
	JAE	HaveMaskForNextChar	; per character fragment

	MOV	AL, BH	; Save left clip amt in AL
	XOR	BH, BH
	SHL	BX, 1	; masks array is a word wide
	MOV	DX, WORD PTR CS:Masks[BX]
	MOV	BH, AL	; Restore left clip amt in AL

HaveMaskForNextChar:
	ROR	DX, CL
	SUB	CL, BH	; Shift less by amount of clip at left
	JNC	CharVertLoop

	ADD	CL, 16

; In this inner loop registers will be used as follows:
;
;  DS:SI => Next part of character to be put on display
;  ES:DI => Next place for character
;  CL    =  Character Shift Amount
;  CH    =  Loop count
;  DX    =  Mask register
;  BX    =  Temporary register
;  AX    =  Temporary register

CharVertLoop:
	LODSB 
	XOR	AH, AH
	ROR	AX, CL
	NOT	DX
	AND	AX, DX
	NOT	DX
	MOV	BX, ES:[DI] 
	AND	BX, DX 
	OR	AX, BX 
	MOV	ES:[DI], AX

	MOV	AL, loc.oddLineFlag	; get buffer flag
	INC	AX	; next line
	AND	AL, 3	; IF AX = 4 (last buffer) THEN
	JNZ	CharVertLoopNextBuffer

	ADD	DI, loc.bplLessRewind	; go back to top
	JMP	SHORT CharVertLoopEnd

CharVertLoopNextBuffer:
	ADD	DI, loc.windowHeight	; go to next buffer
	CMP	AL, loc.edge
	JA	CharVertLoopEnd

	ADD	DI, loc.bytesPerLine

CharVertLoopEnd:
	MOV	loc.oddlineFlag, AL
	DEC	CH
	JNZ	CharVertLoop

	ADD	SI, loc.chBottomClip	; Skip data for part of char clipped at botm

	MOV	DX, DI	; Save char's dest index for east/west info
	POP	DI	; Starting point for the character image
	POP	CX	; Restore char height (in CH)
	POP	BX	; Width of char displayed thus far
	POP	AX	; Restore oddLineFlag

	ADD	BL, BH	; Take left clipped part into account
	CMP	BL, 8	; Check to see if there is more to this char
	JBE	FindCharPosForNextChar	; If not then go do next char

	ADD	CL, 8
	SUB	CL, BH
	CMP	CL, 8
	JB	CharHorizLoopBottom

	SUB	CL, 8
	INC	DI	; Next byte position

CharHorizLoopBottom:
	SUB	BL, 8	; Width left to do for to this char
	XOR	BH, BH	; Clipping only occurs for left of char
	MOV	loc.oddLineFlag, AL	; Restore oddLineFlag
	JMP	SHORT CharHorizLoop	; Do the next part

; At this point need to establish the word and offset position for the next
; char.  It is a little bit different for each screen direction (N,W,S,E).

FindCharPosForNextChar:
	SUB	BL, BH	; Adjust width to reflect part drawn only
	TEST	CS:scrOrientation, westOrEast
	JZ	NextCharPosNorthSouth

NextCharPosEastWest:
	MOV	DI, DX	; Back to "bottom" of last character
	MOV	AL, loc.eachChHeight
	XOR	AH, AH
	DEC	AX	; Determine how many bytes were in last
	SHR	AX, 1	; character so the character destination
	SHR	AX, 1	; (DI) can be put back to where it began
	SHR	AX, 1
	SUB	DI, AX

	MOV	loc.chTopClip, 0	; Top clip only valid for first char
	POP	CX	; Restore count of characters (left)
	CMP	CX, 2	; If next char is not the last (first) char
	JNE	NextCharPosEnd	; then don't change bottom clip amt

	MOV	AX, loc.saveClipAmt
	MOV	loc.chBottomClip, AX
	JMP	SHORT NextCharPosEnd

NextCharPosNorthSouth:
	MOV	loc.oddLineFlag, AL	; Restore oddLineFlag
	ADD	CL, BL
	CMP	CL, 8
	JB	NextCharPosNSEnd

	SUB	CL, 8
	INC	DI	; Use word on odd boundary

NextCharPosNSEnd:
	MOV	loc.nextChShift, CL

	MOV	loc.chLeftClip, 0	; Left clip only valid for first char
	POP	CX	; Restore count of characters (left)
	CMP	CX, 2	; If next char is not the last (first) char
	JNE	NextCharPosEnd	; then don't change right clip amt

	MOV	AX, loc.saveClipAmt
	MOV	loc.chRightClip, AX

NextCharPosEnd:
	MOV	loc.nextChIndex, DI

	POP	SI	; Restore index to beginning of font info
	POP	DI	; Restore index to characters
	POP	ES	; Restore pointer to characters

	ADD	DI, loc.nextChIncDec	; Point to next/prev character
	DEC	CX
	JZ	ScrDrawCharsExit
	JMP	CharMainLoop

ScrDrawCharsExit:
%IF (%supportsEmsWindows EQ 1) THEN (
	POP	AX
	INC	AX
	JZ	ScrDrawCharsRet

	DEC	AX
	CALL	RestoreEmsSlot
) FI

ScrDrawCharsRet:
	MOV	SP, BP
	POP	BP
	POP	DS
	RET	paramBytes
ScrDrawChars ENDP

PURGE params, loc, localBytes, paramBytes
PURGE screen, bytesPerLine, windowHeight
PURGE xLoc, yLoc, xExtent, yExtent
PURGE chTopClip, chLeftClip, chBottomClip, chRightClip
PURGE pChars, numChars, pFontInfo
PURGE oldDS, oldBP, returnIP, returnCS
PURGE edge, oddLineFlag, bplLessRewind, saveClipAmt
PURGE nextChSegment, nextChIndex, nextChIncDec, nextChShift, eachChHeight


CODE ENDS

  END
